/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SpriteShifter;
import com.zurrtum.create.client.foundation.block.connected.AllCTTypes;
import com.zurrtum.create.client.foundation.block.connected.CTSpriteShiftEntry;
import com.zurrtum.create.client.foundation.block.connected.CTSpriteShifter;
import com.zurrtum.create.client.foundation.block.connected.CTType;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1767;
import net.minecraft.class_4719;
import net.minecraft.class_5955;

@Environment(value=EnvType.CLIENT)
public class AllSpriteShifts {
    private static final Map<class_4719, CTSpriteShiftEntry> WOODEN_WINDOWS = new IdentityHashMap<class_4719, CTSpriteShiftEntry>();
    public static final Map<class_5955.class_5811, CTSpriteShiftEntry> COPPER_SHINGLES = new EnumMap<class_5955.class_5811, CTSpriteShiftEntry>(class_5955.class_5811.class);
    public static final Map<class_5955.class_5811, CTSpriteShiftEntry> COPPER_TILES = new EnumMap<class_5955.class_5811, CTSpriteShiftEntry>(class_5955.class_5811.class);
    public static final Map<class_1767, SpriteShiftEntry> DYED_BELTS = new EnumMap<class_1767, SpriteShiftEntry>(class_1767.class);
    public static final Map<class_1767, SpriteShiftEntry> DYED_OFFSET_BELTS = new EnumMap<class_1767, SpriteShiftEntry>(class_1767.class);
    public static final Map<class_1767, SpriteShiftEntry> DYED_DIAGONAL_BELTS = new EnumMap<class_1767, SpriteShiftEntry>(class_1767.class);
    public static final SpriteShiftEntry BURNER_FLAME = AllSpriteShifts.get("block/blaze_burner_flame", "block/blaze_burner_flame_scroll");
    public static final SpriteShiftEntry SUPER_BURNER_FLAME = AllSpriteShifts.get("block/blaze_burner_flame", "block/blaze_burner_flame_superheated_scroll");
    public static final CTSpriteShiftEntry ANDESITE_SCAFFOLD = AllSpriteShifts.horizontal("scaffold/andesite_scaffold");
    public static final CTSpriteShiftEntry BRASS_SCAFFOLD = AllSpriteShifts.horizontal("scaffold/brass_scaffold");
    public static final CTSpriteShiftEntry COPPER_SCAFFOLD = AllSpriteShifts.horizontal("scaffold/copper_scaffold");
    public static final CTSpriteShiftEntry ANDESITE_SCAFFOLD_INSIDE = AllSpriteShifts.horizontal("scaffold/andesite_scaffold_inside");
    public static final CTSpriteShiftEntry BRASS_SCAFFOLD_INSIDE = AllSpriteShifts.horizontal("scaffold/brass_scaffold_inside");
    public static final CTSpriteShiftEntry COPPER_SCAFFOLD_INSIDE = AllSpriteShifts.horizontal("scaffold/copper_scaffold_inside");
    public static final CTSpriteShiftEntry FRAMED_GLASS = AllSpriteShifts.getCT(AllCTTypes.OMNIDIRECTIONAL, "palettes/framed_glass", "palettes/framed_glass");
    public static final CTSpriteShiftEntry HORIZONTAL_FRAMED_GLASS = AllSpriteShifts.getCT(AllCTTypes.HORIZONTAL_KRYPPERS, "palettes/framed_glass", "palettes/horizontal_framed_glass");
    public static final CTSpriteShiftEntry VERTICAL_FRAMED_GLASS = AllSpriteShifts.getCT(AllCTTypes.VERTICAL, "palettes/framed_glass", "palettes/vertical_framed_glass");
    public static final CTSpriteShiftEntry ORNATE_IRON_WINDOW = AllSpriteShifts.vertical("palettes/ornate_iron_window");
    public static final CTSpriteShiftEntry INDUSTRIAL_IRON_WINDOW = AllSpriteShifts.getCT(AllCTTypes.RECTANGLE, "palettes/industrial_iron_window");
    public static final CTSpriteShiftEntry OLD_FACTORY_WINDOW_1 = AllSpriteShifts.getCT(AllCTTypes.RECTANGLE, "palettes/weathered_iron_window", "palettes/weathered_iron_window_1");
    public static final CTSpriteShiftEntry OLD_FACTORY_WINDOW_2 = AllSpriteShifts.getCT(AllCTTypes.RECTANGLE, "palettes/weathered_iron_window", "palettes/weathered_iron_window_2");
    public static final CTSpriteShiftEntry OLD_FACTORY_WINDOW_3 = AllSpriteShifts.getCT(AllCTTypes.RECTANGLE, "palettes/weathered_iron_window", "palettes/weathered_iron_window_3");
    public static final CTSpriteShiftEntry OLD_FACTORY_WINDOW_4 = AllSpriteShifts.getCT(AllCTTypes.RECTANGLE, "palettes/weathered_iron_window", "palettes/weathered_iron_window_4");
    public static final CTSpriteShiftEntry CRAFTER_SIDE = AllSpriteShifts.vertical("crafter_side");
    public static final CTSpriteShiftEntry CRAFTER_OTHERSIDE = AllSpriteShifts.horizontal("crafter_side");
    public static final CTSpriteShiftEntry ANDESITE_ENCASED_COGWHEEL_SIDE = AllSpriteShifts.vertical("andesite_encased_cogwheel_side");
    public static final CTSpriteShiftEntry ANDESITE_ENCASED_COGWHEEL_OTHERSIDE = AllSpriteShifts.horizontal("andesite_encased_cogwheel_side");
    public static final CTSpriteShiftEntry BRASS_ENCASED_COGWHEEL_SIDE = AllSpriteShifts.vertical("brass_encased_cogwheel_side");
    public static final CTSpriteShiftEntry BRASS_ENCASED_COGWHEEL_OTHERSIDE = AllSpriteShifts.horizontal("brass_encased_cogwheel_side");
    public static final CTSpriteShiftEntry GIRDER_POLE = AllSpriteShifts.vertical("girder_pole_side");
    public static final CTSpriteShiftEntry ANDESITE_CASING = AllSpriteShifts.omni("andesite_casing");
    public static final CTSpriteShiftEntry BRASS_CASING = AllSpriteShifts.omni("brass_casing");
    public static final CTSpriteShiftEntry COPPER_CASING = AllSpriteShifts.omni("copper_casing");
    public static final CTSpriteShiftEntry SHADOW_STEEL_CASING = AllSpriteShifts.omni("shadow_steel_casing");
    public static final CTSpriteShiftEntry REFINED_RADIANCE_CASING = AllSpriteShifts.omni("refined_radiance_casing");
    public static final CTSpriteShiftEntry RAILWAY_CASING = AllSpriteShifts.omni("railway_casing");
    public static final CTSpriteShiftEntry RAILWAY_CASING_SIDE = AllSpriteShifts.omni("railway_casing_side");
    public static final CTSpriteShiftEntry CREATIVE_CASING = AllSpriteShifts.getCT(AllCTTypes.RECTANGLE, "creative_casing");
    public static final CTSpriteShiftEntry CHASSIS_SIDE = AllSpriteShifts.omni("linear_chassis_side");
    public static final CTSpriteShiftEntry SECONDARY_CHASSIS_SIDE = AllSpriteShifts.omni("secondary_linear_chassis_side");
    public static final CTSpriteShiftEntry CHASSIS = AllSpriteShifts.omni("linear_chassis_end");
    public static final CTSpriteShiftEntry CHASSIS_STICKY = AllSpriteShifts.omni("linear_chassis_end_sticky");
    public static final CTSpriteShiftEntry BRASS_TUNNEL_TOP = AllSpriteShifts.vertical("tunnel/brass_tunnel_top");
    public static final CTSpriteShiftEntry FLUID_TANK = AllSpriteShifts.getCT(AllCTTypes.RECTANGLE, "fluid_tank");
    public static final CTSpriteShiftEntry FLUID_TANK_TOP = AllSpriteShifts.getCT(AllCTTypes.RECTANGLE, "fluid_tank_top");
    public static final CTSpriteShiftEntry FLUID_TANK_INNER = AllSpriteShifts.getCT(AllCTTypes.RECTANGLE, "fluid_tank_inner");
    public static final CTSpriteShiftEntry CREATIVE_FLUID_TANK = AllSpriteShifts.getCT(AllCTTypes.RECTANGLE, "creative_fluid_tank");
    public static final Couple<CTSpriteShiftEntry> VAULT_TOP = AllSpriteShifts.vault("top");
    public static final Couple<CTSpriteShiftEntry> VAULT_FRONT = AllSpriteShifts.vault("front");
    public static final Couple<CTSpriteShiftEntry> VAULT_SIDE = AllSpriteShifts.vault("side");
    public static final Couple<CTSpriteShiftEntry> VAULT_BOTTOM = AllSpriteShifts.vault("bottom");
    public static final SpriteShiftEntry ELEVATOR_BELT = AllSpriteShifts.get("block/elevator_pulley_belt", "block/elevator_pulley_belt_scroll");
    public static final SpriteShiftEntry ROPE_PULLEY_COIL = AllSpriteShifts.get("block/rope_pulley_coil", "block/rope_pulley_coil_scroll");
    public static final SpriteShiftEntry ELEVATOR_COIL = AllSpriteShifts.get("block/elevator_pulley_coil", "block/elevator_pulley_coil_scroll");
    public static final SpriteShiftEntry HOSE_PULLEY_COIL = AllSpriteShifts.get("block/hose_pulley_coil", "block/hose_pulley_coil_scroll");
    public static final SpriteShiftEntry FACTORY_PANEL_CONNECTIONS = AllSpriteShifts.get("block/factory_panel_connections", "block/factory_panel_connections_animated");
    public static final SpriteShiftEntry BELT = AllSpriteShifts.get("block/belt", "block/belt_scroll");
    public static final SpriteShiftEntry BELT_OFFSET = AllSpriteShifts.get("block/belt_offset", "block/belt_scroll");
    public static final SpriteShiftEntry BELT_DIAGONAL = AllSpriteShifts.get("block/belt_diagonal", "block/belt_diagonal_scroll");
    public static final SpriteShiftEntry ANDESIDE_BELT_CASING = AllSpriteShifts.get("block/belt/brass_belt_casing", "block/belt/andesite_belt_casing");
    public static final SpriteShiftEntry CRAFTER_THINGIES = AllSpriteShifts.get("block/crafter_thingies", "block/crafter_thingies");
    public static final SpriteShiftEntry BOGEY_BELT = AllSpriteShifts.get("block/bogey/belt", "block/bogey/belt_scroll");

    private static void populateMaps() {
        class_4719[] supportedWoodTypes = new class_4719[]{class_4719.field_21676, class_4719.field_21677, class_4719.field_21678, class_4719.field_21679, class_4719.field_21680, class_4719.field_21681, class_4719.field_37657, class_4719.field_22183, class_4719.field_22184, class_4719.field_42837, class_4719.field_40350};
        Arrays.stream(supportedWoodTypes).forEach(woodType -> WOODEN_WINDOWS.put((class_4719)woodType, AllSpriteShifts.vertical("palettes/" + woodType.comp_1299() + "_window")));
        for (class_1767 class_17672 : class_1767.values()) {
            String id = class_17672.method_15434();
            DYED_BELTS.put(class_17672, AllSpriteShifts.get("block/belt", "block/belt/" + id + "_scroll"));
            DYED_OFFSET_BELTS.put(class_17672, AllSpriteShifts.get("block/belt_offset", "block/belt/" + id + "_scroll"));
            DYED_DIAGONAL_BELTS.put(class_17672, AllSpriteShifts.get("block/belt_diagonal", "block/belt/" + id + "_diagonal_scroll"));
        }
        for (class_1767 class_17673 : class_5955.class_5811.values()) {
            String pref = "copper/" + (String)(class_17673 == class_5955.class_5811.field_28704 ? "" : Lang.asId(class_17673.name()) + "_");
            COPPER_SHINGLES.put((class_5955.class_5811)class_17673, AllSpriteShifts.getCT(AllCTTypes.ROOF, pref + "copper_roof_top", pref + "copper_shingles_top"));
            COPPER_TILES.put((class_5955.class_5811)class_17673, AllSpriteShifts.getCT(AllCTTypes.ROOF, pref + "copper_roof_top", pref + "copper_tiles_top"));
        }
    }

    private static Couple<CTSpriteShiftEntry> vault(String name) {
        String prefixed = "block/vault/vault_" + name;
        return Couple.createWithContext(medium -> CTSpriteShifter.getCT(AllCTTypes.RECTANGLE, Create.asResource(prefixed + "_small"), Create.asResource(medium != false ? prefixed + "_medium" : prefixed + "_large")));
    }

    private static CTSpriteShiftEntry omni(String name) {
        return AllSpriteShifts.getCT(AllCTTypes.OMNIDIRECTIONAL, name);
    }

    private static CTSpriteShiftEntry horizontal(String name) {
        return AllSpriteShifts.getCT(AllCTTypes.HORIZONTAL, name);
    }

    private static CTSpriteShiftEntry vertical(String name) {
        return AllSpriteShifts.getCT(AllCTTypes.VERTICAL, name);
    }

    private static SpriteShiftEntry get(String originalLocation, String targetLocation) {
        return SpriteShifter.get(Create.asResource(originalLocation), Create.asResource(targetLocation));
    }

    private static CTSpriteShiftEntry getCT(CTType type, String blockTextureName, String connectedTextureName) {
        return CTSpriteShifter.getCT(type, Create.asResource("block/" + blockTextureName), Create.asResource("block/" + connectedTextureName + "_connected"));
    }

    private static CTSpriteShiftEntry getCT(CTType type, String blockTextureName) {
        return AllSpriteShifts.getCT(type, blockTextureName, blockTextureName);
    }

    public static CTSpriteShiftEntry getWoodenWindow(class_4719 woodType) {
        return WOODEN_WINDOWS.get(woodType);
    }

    static {
        AllSpriteShifts.populateMaps();
    }
}

